from collections import Counter

def solve_query(a, k):
    """
    Rešava jedan upit tipa 1.
    
    Args:
        a: Lista karata
        k: Pocetni broj karata u ruci
    
    Returns:
        Minimalna suma karata u ruci nakon igre
    """
    n = len(a)
    
    # Ako su sve karte vec u ruci, vracamo njihovu sumu
    if k >= n:
        return sum(a[:n])
    
    # Pocetne karte u ruci
    hand = a[:k]
    
    # Prolazimo kroz preostale karte
    for j in range(k, n):
        # Dodajemo novu kartu u ruku
        hand.append(a[j])
        
        # Brojimo ucestalost svake karte
        counter = Counter(hand)
        
        # Biramo kartu sa najviše pojavljivanja
        # Ako ima više sa istim brojem pojavljivanja, biramo onu sa najvecom vrednošcu
        max_count = max(counter.values())
        best_card = max(card for card, count in counter.items() if count == max_count)
        
        # Uklanjamo sve instance te karte
        hand = [card for card in hand if card != best_card]
    
    return sum(hand)



n, q = map(int, input().split())
a = list(map(int, input().split()))

# Obrada upita
for _ in range(q):
    query = list(map(int, input().split()))
    
    if query[0] == 1:
        # Tip 1: Izracunaj minimalnu sumu
        k = query[1]
        result = solve_query(a, k)
        print(result)
    else:
        # Tip 2: Ažuriraj kartu
        x, y = query[1], query[2]
        a[x - 1] = y  # Indeksiranje od 0